// includes, system
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

// includes, project
#include <cutil_inline.h>

// includes, kernels
#include <zad1_kernel.cu>


int main( int argc, char** argv) {
	// wybiera GPU podane z linii komend,
	// badz te o najwiekszej ilosci GFLOPS.
	if( cutCheckCmdLineFlag(argc, (const char**)argv, "device") )
		cutilDeviceInit(argc, argv);
	else
		cudaSetDevice( cutGetMaxGflopsDeviceId() );

    int num_threads = 16; // podzielne przez 4
    int mem_size = sizeof(int) * num_threads;

    int* h_data = (int*)malloc(mem_size);
    int* d_data;
    cutilSafeCall( cudaMalloc( (void**) &d_data, mem_size));
	cutilSafeCall( cudaMemset( d_data, 0, mem_size));
	// ustawia rozmiar kraty i bloku
    dim3  grid(num_threads/4, 1, 1);
    dim3  threads(4, 1, 1);

    // uruchom kernel
    zad1Kernel<<< grid, threads >>>( d_data);

    // sprawdz, czy kernel zakonczyl sie sukcesem
    cutilCheckMsg("Kernel execution failed");

    // kopiuje wynik z GPU do pamieci komputera
    cutilSafeCall( cudaMemcpy( h_data, d_data, mem_size,
                                cudaMemcpyDeviceToHost) );

	for(int i = 0; i < num_threads; ++i)
		printf("%d ",h_data[i]);

    // zwalnianie pamieci
    free( h_data);
    cutilSafeCall(cudaFree(d_data));

    cudaThreadExit();
    cutilExit(argc, argv);
}
